/*******************************************************
Filename		:  co_op_addr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Cooperating Organization Physical Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/16/2006.
Comments		:  
**********************************************************/

/****************************************************************************
Create sequences for MetaData Cooperating Organization Physical Address table
*****************************************************************************/
set echo on 
spool co_op_addr.log

--drop sequence seq_md_coop_address;

create sequence seq_md_coop_address
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/**************************************************************
Create MetaData Cooperating Organization Physical Address table
***************************************************************/
--drop table md_coop_address;

create table md_coop_address
( pk_isn number(12,0),
  coop_addr_is_number number(12,0) not null,
  organization_id VARCHAR2(256 char) not null,
  coop_addr_type VARCHAR2(256 char) not null,
  address_one_text VARCHAR2(256 char),
  address_two_text VARCHAR2(256 char),
  address_three_text VARCHAR2(256 char),
  address_four_text VARCHAR2(256 char),
  country_code VARCHAR2(256 char),
  start_date DATE,
  coop_org_is_number number(12,0));
  
alter table md_coop_address
add constraint pk_co_op_addr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index iacoorgid on md_coop_address(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;


/* moved to after insert

alter table md_coop_address
add( fk_coop number(12,0));

update  md_coop_address oa
set fk_coop =(select pk_isn from md_coop op
              where op.coop_org_is_number=oa.coop_org_is_number
              and op.organization_id = oa.organization_id)
where oa.coop_org_is_number is not null;
commit;

create index iacoop on md_coop_address(fk_coop)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_coop_address
add constraint fk_md_acoop foreign key (fk_coop) references md_coop(pk_isn);

commit;
*/
/***************************************************************************
Populate MetaData Cooperating Organization  Physical Address table with data.
***************************************************************************/
 serveroutput on
declare 
cursor c_coop_addr is 
select AD.TSMADDR_IS_NUMBER,AD.TSMADDR_ORG_ID,AD.TYPE_CODE,AD.LINE_ONE_TEXT,AD.LINE_TWO_TEXT,AD.LINE_THREE_TEXT,AD.LINE_FOUR_TEXT,AD.COUNTRY_CODE,AD.START_DATE,AD.TSMCPORG_IS_NUMBER
from storet1.tsmaddr AD,storetw.md_coop cp
where AD.tsmcporg_is_number = CP.coop_org_is_number
and AD.tsmcporg_org_id =CP.organization_id;

begin
  for c_var in c_coop_addr loop
    insert into md_coop_address
    (pk_isn,coop_addr_is_number,organization_id,coop_addr_type,address_one_text,address_two_text,address_three_text,address_four_text,country_code,start_date,coop_org_is_number)
    values
    (seq_md_coop_address.nextval,c_var.tsmaddr_is_number,c_var.tsmaddr_org_id,c_var.type_code,c_var.line_one_text,c_var.line_two_text,c_var.line_three_text,c_var.line_four_text,c_var.country_code,c_var.start_date,c_var.tsmcporg_is_number);
  end loop;
  commit;
end;
/

alter table md_coop_address
add( fk_coop number(12,0));

update  md_coop_address oa
set fk_coop =(select pk_isn from md_coop op
              where op.coop_org_is_number=oa.coop_org_is_number
              and op.organization_id = oa.organization_id)
where oa.coop_org_is_number is not null;
commit;

create index iacoop on md_coop_address(fk_coop)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_coop_address
add constraint fk_md_acoop foreign key (fk_coop) references md_coop(pk_isn);

commit;

alter table md_coop_address add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_coop_address add SOURCE_UID NUMBER(20);
commit;

alter table md_coop_address modify coop_addr_is_number number(12,0) null;


spool off;
